#pragma once

#include <ads/bsyeti/libs/vinyl/cstring.h>
#include <ads/bsyeti/libs/vinyl/hash.h>

namespace NAudience::NSegmentPriorities {
    template <class M>
    struct TPrioritiesV1 {
        ui64 DefaultPriority;
        NVinyl::THashMap<M, ui64, ui64> Priorities;
    };

    template <class M>
    using TPrioritiesDictV1 = NVinyl::THashMap<M, NVinyl::TCString<M>, TPrioritiesV1<M>>;

    template <class M>
    struct TBaseV1 {
        static constexpr size_t VINYL_VERSION = 1u;

        TPrioritiesDictV1<M> Data;
    };
}
