#include "builder.h"

#include <ads/bsyeti/libs/vinyl/burn.h>
#include <util/stream/file.h>

namespace NAudience::NSegmentPriorities {
    void SaveToFile(const TBaseEditor& base, const TString& filename) {
        TFileOutput out(filename);
        NVinyl::Burn(out, base, "Audience segments priorities", TBaseEditor::VINYL_VERSION);
        out.Flush();
    }

    TBaseEditor BuildFromProto(const TPrioritiesByType& proto) {
        TBaseEditor base;

        for (const auto& [key, priorities]: proto.GetPrioritiesByType()) {
            auto& vinylPriorities = base.Data[key];
            vinylPriorities.DefaultPriority = priorities.GetDefaultPriority();
            for (const auto& [segment, priority]: priorities.GetPriorities()) {
                vinylPriorities.Priorities[segment] = priority;
            }
        }

        return base;
    }
}
