#include "reader.h"
#include "base.h"

#include <ads/bsyeti/libs/vinyl/mount.h>

namespace NAudience::NSegmentPriorities {
    TBaseHolder Mount(const TString& filename, bool lockInMemory) {
        return NVinyl::Mount<TBaseView>(filename, TBaseView::VINYL_VERSION, lockInMemory);
    }

    NAudience::TPrioritiesByType ReadBaseToProto(const TString& rawBase) {
        const auto& blob = TBlob::FromString(rawBase);
        const auto& base = NVinyl::Mount<TBaseView>(blob, TBaseView::VINYL_VERSION, false);

        NAudience::TPrioritiesByType result;

        for (const auto& [key, priorities]: base->Data) {
            auto& protoPriorities = (*result.MutablePrioritiesByType())[TString(key)];

            protoPriorities.SetDefaultPriority(priorities.DefaultPriority);
            auto& mapping = *protoPriorities.MutablePriorities();

            for (const auto& [segment, priority]: priorities.Priorities) {
                mapping[segment] = priority;
            }
        }

        return result;
    }
}
