#include <library/cpp/dot_product/dot_product.h>
#include <crypta/audience/lib/native/stats.h>

using namespace NYT;
using namespace NAudience;

void TPruneUserData::Start(TTableWriter<TPrunedUserData>*) {
    UsedStrataSegments.Clear();
    const auto& repeatedSegments = State->GetUsedStrataSegments().GetSegment();
    TSet<NLab::TSegment> segments(repeatedSegments.begin(), repeatedSegments.end());
    UsedStrataSegments = segments;

    const auto rows = State->GetProjectionMat().GetMat();

    ProjectionMat.clear();
    for (const auto& row : rows.GetRows()) {
        const auto& data = row.GetData();
        TVector<float> vec(data.begin(), data.end());
        ProjectionMat.push_back(vec);
    }
}

void TPruneUserData::Do(TTableReader<NLab::TUserData>* input, TTableWriter<TPrunedUserData>* output) {
    for (; input->IsValid(); input->Next()) {
        NLab::TUserData userData = input->GetRow();
        userData.ClearAffinities();
        NLab::TVectorType result;
        auto newSize = ProjectionMat.size();
        result.MutableData()->Resize(newSize, 0);
        for (ui64 i = 0; i < newSize; ++i) {
            auto& vec = userData.GetVectors().GetVector().GetData();
            result.MutableData()->mutable_data()[i] = DotProduct(
                ProjectionMat[i].data(),
                vec.data(),
                vec.size());
        }
        NLab::Normalize(result);
        userData.MutableVectors()->MutableVector()->CopyFrom(result);
        NLab::TUserData::TSegments segments;
        for (const auto& segment : userData.GetSegments().GetSegment()) {
            if (!IgnoreStrataSegment(UsedStrataSegments, segment)) {
                segments.AddSegment()->CopyFrom(segment);
            }
        }
        userData.MutableSegments()->CopyFrom(segments);

        TPrunedUserData out;
        out.MutableUserData()->CopyFrom(userData);
        out.SetUserID(FromString<ui64>(userData.GetYandexuid()));
        output->AddRow(out);
    }
}
