#pragma once

#include <crypta/audience/proto/audience_geo.pb.h>
#include <crypta/lab/lib/native/stats.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/proto/user_data/math.pb.h>

#include <util/generic/set.h>

using namespace NYT;
using namespace NAudience;

class TPruneUserData: public TStateful<TPrunedOptions, IMapper<TTableReader<NLab::TUserData>, TTableWriter<TPrunedUserData>>> {
public:
    TPruneUserData()
        : TStateful()
    {
    }
    TPruneUserData(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }
    void Start(TTableWriter<TPrunedUserData>*) override;
    void Do(TTableReader<NLab::TUserData>* input, TTableWriter<TPrunedUserData>* output) override;

private:
    TMaybe<TSet<NLab::TSegment>> UsedStrataSegments{};
    TVector<TVector<float>> ProjectionMat{};
};
