#pragma once

#include "id_hash.h"

#include <ads/bsyeti/libs/experiments/builder.h>
#include <mapreduce/yt/interface/operation.h>
#include <library/cpp/bloom_filter/bloomfilter.h>
#include <crypta/audience/proto/storage.pb.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/sampler/hash_sampler.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/native/yt/dyntables/proto/key_value.pb.h>
#include <util/folder/dirut.h>
#include <util/generic/buffer.h>
#include <util/string/cast.h>

using namespace NAudience;
using namespace NYT;

class TFilterStorage
   : public IMapper<TTableReader<TStorageEntry>, TTableWriter<TStorageEntry>> {
public:
    TFilterStorage();

    void Do(TTableReader<TStorageEntry>* input, TTableWriter<TStorageEntry>* output) override;
};

class TCombineIntoJson: public IReducer<TTableReader<TStorageEntry>, TTableWriter<TNode>> {
public:
    TCombineIntoJson();
    TCombineIntoJson(const TBuffer& timestamp);

    void Do(TTableReader<TStorageEntry>* input, TTableWriter<TNode>* output) override;

    Y_SAVELOAD_JOB(Timestamp);

private:
    ui64 Timestamp;
};

class TPartitionStorageCryptaID
   : public IMapper<TTableReader<TCryptaIdStorageEntry>, TTableWriter<TCryptaIdStorageEntry>> {
public:
    TPartitionStorageCryptaID();

    void Do(TTableReader<TCryptaIdStorageEntry>* input, TTableWriter<TCryptaIdStorageEntry>* output) override;
};

class TCombineIntoJsonCryptaID: public TStateful<TCryptaIdStorageCombineState, IReducer<TTableReader<TCryptaIdStorageEntry>, TTableWriter<TNode>>> {
public:
    TCombineIntoJsonCryptaID();
    TCombineIntoJsonCryptaID(const TBuffer& timestamp);

    void Do(TTableReader<TCryptaIdStorageEntry>* input, TTableWriter<TNode>* output) override;
};

class TPartitionStorageDevices
   : public IMapper<TTableReader<TNode>, TTableWriter<TNode>> {
public:
    TPartitionStorageDevices();

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TCombineIntoJsonDevices: public TStateful<TDevicesStorageCombineState, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TCombineIntoJsonDevices();
    TCombineIntoJsonDevices(const TBuffer& timestamp);

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TUpdateFullState: public TStateful<TUpdateFullStateState, IReducer<TTableReader<::google::protobuf::Message>, TTableWriter<::google::protobuf::Message>>> {
public:
    TUpdateFullState();
    TUpdateFullState(const TBuffer& state);

    void Do(TReader* input, TWriter* output) override;
    void Start(TWriter*) override;

    using TInputs = std::tuple<TFullBinding, TFullBinding, TIdMeta>;
    using TOutputs = std::tuple<TFullBinding, TUserSegmentsRow, TIdMeta, TFullBinding, TUserSegmentsRow>;

private:
    class TBindingStatus {
    public:
        TBindingStatus(const TUpdateFullStateState::TSegmentState& segmentState);

        void SetHasState();
        void SetHasUpdate();
        bool WasRemoved() const;
        bool WasAdded() const;
        ui64 GetTimestamp() const;

    private:
        bool HasState = false;
        bool HasUpdate = false;
        const TUpdateFullStateState::TSegmentState& SegmentState;
    };

    const TUpdateFullStateState::TSegmentState& GetSegmentState(i64 segmentId);
    void Clear();
    void Read(TReader* input);
    void WriteState(TWriter* output);
    void WriteCollectorAndMeta(TWriter* output);

    enum class EInputIndex {
        State = 0,
        SegmentUpdates = 1,
        Meta = 2
    };

    enum class EOutputIndex {
        State = 0,
        Collector = 1,
        Meta = 2,
        SampleLog = 3,
        SampleCollector = 4
    };

    TIdMeta IdMeta;
    TMaybe<TString> OtherColumns;
    THashMap<i64, TBindingStatus> BindingStatuses;
    NCrypta::THashSampler<IdHash> Sampler;
    TVector<i64> Segments;
    bool OutputToSampleLog = false;
};

i64 ToExportSegmentId(i64 audienceSegmentId);
