from util.generic.string cimport TString

from crypta.audience.lib.native.segment_priorities.builder cimport (
    TPrioritiesByType as TPrioritiesByTypeNative,
    SaveToFile,
    BuildFromProto,
    ReadBaseToProto,
)
from crypta.audience.proto import storage_pb2


def convert_proto_to_vinyl(proto, filename):
    cdef TPrioritiesByTypeNative priorities_by_type
    priorities_by_type.ParseFromString(proto.SerializeToString())
    SaveToFile(BuildFromProto(priorities_by_type), filename)


def convert_vinyl_to_proto(raw):
    cdef TPrioritiesByTypeNative priorities_by_type = ReadBaseToProto(raw)

    cdef TString buffer
    priorities_by_type.SerializeToString(&buffer)

    proto = storage_pb2.TPrioritiesByType()
    proto.ParseFromString(buffer)

    return proto
