import logging

from crypta.audience.lib.tasks import base
from crypta.audience.lib.tasks.audience import tables
from crypta.lib.python.bt import workflow
from crypta.lib.python.bt.commons import dates
from crypta.lib.python.bt.conf import conf
from crypta.lib.python.bt.workflow.targets import table

logger = logging.getLogger(__name__)


class PrecomputeCommunalities(base.YtTask, workflow.IndependentTask):
    day = workflow.Parameter(parse=dates.parse_day)

    def targets(self):
        yield table.HasAttribute(
            self.yt,
            conf.paths.audience.dynamic.properties,
            tables.SegmentPropertiesStorage.LAST_COMMUNALITY_QUANTILES_UPDATE_DATE,
            str(self.day)
        )

    def run(self, **kwargs):
        storage_client = self._init_yt()
        with tables.SegmentPropertiesStorage(storage_client, experiment_mode=True).batched_inserter as properties_inserter:
            properties_inserter.storage.compute_communality_quantiles()
