import datetime
import time as libtime

import logging
logger = logging.getLogger(__name__)


def write_segment_on_input(segment_id, row_count, time, state_inserter=None, segment_type='audience'):
    if state_inserter:
        state_inserter.insert_row(segment_id, segment_type, is_input=True,
                                         row_count=row_count, timestamp=int(libtime.mktime(time.timetuple())))


def write_segment_on_output(segment_id, row_count, time, state_inserter=None, segment_type='audience'):
    if state_inserter:
        state_inserter.insert_row(segment_id, segment_type, is_input=False,
                                         row_count=row_count, timestamp=int(libtime.mktime(time.timetuple())))


def write_segment_properties(segment_id, communality, segment_type, time=None, inserter=None):
    if time is None:
        time = datetime.datetime.now()

    if inserter:
        timestamp = int(libtime.mktime(time.timetuple()))
        inserter.insert_row(segment_id, segment_type, communality, timestamp)


def write_segment_goal_relation(segment_id, goal_id, cosine, inserter=None):
    if inserter:
        inserter.insert_row(segment_id, goal_id, cosine)
