from crypta.audience.lib.tasks.constants import YUID, YANDEXUID  # noqa


COUNT = 'count'

TITLES, REQUESTS, URLS, APPS, GOALS = \
    ('titles', 'requests', 'urls', 'app', 'goals')

AGE = 'age'
SEX = 'sex'
DEVICE = 'device'
REGION = 'region'
INCOME = 'income'
PLATFORM = 'platform'


FACTORS = (SEX, AGE, DEVICE, INCOME, REGION, PLATFORM)
PROBABILITY_FACTORS = (AGE, DEVICE, INCOME, REGION, PLATFORM, SEX)
OUTPUT_FACTORS = (AGE, DEVICE, REGION, SEX)
FILTERING_FACTORS = (DEVICE, PLATFORM, REGION)

USER_FEATURES = (TITLES, REQUESTS, URLS, APPS)

SEGMENT_TYPE = 'crypta_segment_type'
OPTIONS = 'options'
RELATED_GOALS = 'crypta_related_goals'
ENFORCE_DEVICE_AND_PLATFORM = 'enforce_device_and_platform'
ENFORCE_REGION = 'enforce_region'
NUM_OUTPUT_BUCKETS = 'num_output_buckets'

# this is a rolling update thing, should be dropped right away
DEFAULT_SEGMENT_TYPE = 'audience'

VOLATILE_ID = 'volatile_id'
PERMANENT_ID = 'permanent_id'
OWNER_ID = 'owner_id'
PRIORITY = 'priority'

FILTER = 'filter'
STATS = 'stats'
TOKENS_COUNT = 'tokens_count'
OUTPUT_STATS = 'output_stats'
OUTPUT_BUCKET_STATS = 'output_bucket_stats'
QUALITY = 'quality'
FILTER_CAPACITY = 'filter_capacity'
LOOKALIKE_AUDIENCE_TYPE = 'audience'

RECALL = 'recall'
BUCKET_SIZE = 'bucket_size'
TEST_SIZE = 'test_size'
INPUT_SEGMENT_SIZE = 'input_segment_size'
OUTPUT_SEGMENT_SIZE = 'output_segment_size'
MAX_COVERAGE = 'max_coverage'
INCLUDE_INPUT = 'include_input'

MAPPER_HIGH_MEMORY_USAGE = {'mapper': {'memory_limit': 1024*1024*1024*8}}
MAPPER_MEDIUM_MEMORY_USAGE = {'mapper': {'memory_limit': 1024*1024*1024*2}}
REDUCER_HIGH_MEMORY_USAGE = {'reducer': {'memory_limit': 1024*1024*1024*8}}

ALLOW_BIG_ROWS = {
    "job_io": {
        "table_writer": {
            "max_row_weight": 128 * 1024 * 1024
        }
    }
}

REDUCER_BIG_ROWS = {
    "reduce_job_io": {
        "table_writer": {
            "max_row_weight": 128*1024*1024
        }
    }
}

TYPE_MODEL = 'type_model'
VECTOR_SIM_MODEL = 'vector_sim'
NN_MODEL = 'nn'

VECTORS = {'vector_b': 256, 'vector_m': 256}

TOTAL_SEGMENT = 0
EXAMINED_SEGMENT = -1
EQ_TOTAL_SEGMENT = -2
EQ_EXAMINED_SEGMENT = -3

TIMESTAMP = 'ts'
ID_VALUE = 'id_value'
SCORE = 'score'
MINUS_SCORE = '_score'
SCORES = 'scores'
SIZE = 'size'
WEIGHT = 'weight'
LABEL = 'label'
LABELS = 'labels'
METRICS = 'metrics'
