import numpy as np
from crypta.lib.python.bt.commons.vector import (
    cosine,
)


def _get_mean(statistic):
    vector = np.array(statistic.Mean.Data)
    vector /= statistic.Count
    return vector


def _get_mean_and_covariance(statistic):
    mean = _get_mean(statistic)
    covariance = np.array(statistic.Covariance.Data).reshape((mean.size, mean.size))
    covariance /= statistic.Count
    covariance -= np.outer(mean, mean)
    return mean, covariance


def _similarity(lhs_stats, rhs_stats):
    lhs_mean_vector = _get_mean(lhs_stats.Distributions.Main)
    rhs_mean_vector = _get_mean(rhs_stats.Distributions.Main)
    if not lhs_mean_vector.size or not rhs_mean_vector.size:
        return 0.0
    return cosine(lhs_mean_vector, rhs_mean_vector)
