import datetime

from yt.wrapper.common import date_string_to_timestamp

from crypta.audience.lib.tasks import audience
from crypta.audience.lib.watchman import lookalike
from crypta.lib.python import time_utils
from crypta.lib.python.bt.conf import conf


def batches_count(client):
    batches_path = conf.paths.audience.batches
    if not client.exists(batches_path):
        return 0
    total = 0
    for batch in client.search(batches_path, node_type='table', attributes=[audience.tables.InputBatch.Meta.META]):
        meta = batch.attributes.get(audience.tables.InputBatch.Meta.META, None)
        if meta:
            total += len(meta.get(audience.tables.InputBatch.Meta.SEGMENTS, []))
    return total


def get_userdata_age(client, path, now):
    if client.exists(path):
        creation_time = date_string_to_timestamp(
            client.get_attribute(path, '_last_update_date') + 'T0:0:0.0Z'
        )
        return int(now - creation_time)
    else:
        return 0


def get_table_size(client, path):
    return client.get_attribute(path, 'row_count') if client.exists(path) else 0


def get_directory_count(client, path):
    return client.get_attribute(path, 'count') if client.exists(path) else 0


def get_throughput(client):
    r = list(client.select_rows("""
        sum(1)
        from [{}]
        where OutputTimestamp > {}
        group by 1
    """.format(
        conf.paths.audience.dynamic.states.regular,
        time_utils.get_current_time() - int(datetime.timedelta(hours=1).total_seconds()),
    )))
    return r[0]['sum(1)'] if r else 0


def metrics(client):
    now = time_utils.get_current_time()
    userdata = conf.paths.lab.data.userdata

    points = [
        ('input_size', get_directory_count(client, conf.paths.audience.input)),
        ('batches_size', batches_count(client)),
        ('output_size', get_directory_count(client, conf.paths.audience.output)),
        ('userdata_age', get_userdata_age(client, userdata, now)),
        ('userdata_size', get_table_size(client, userdata)),
        ('for_full_count', get_directory_count(client, conf.paths.storage.for_full)),
        ('queue_count', get_directory_count(client, conf.paths.storage.queue)),
        ('throughput', get_throughput(client))
    ]
    points = lookalike.extend_with_time_stats(points, audience.tables.RegularSegmentStateStorage(client))

    return points
