import logging
import os

import yt.wrapper as yt

from crypta.audience.lib.watchman import (
    audience,
    lookalike,
    workflow,
    yt_usage,
)
from crypta.lib.python import getoptpb
import crypta.lib.python.bt.conf.conf as conf
from crypta.lib.python.solomon import reporter


def yt_clusters():
    return os.environ.get('YT_CLUSTERS').split(',')


def zk_hosts_and_port():
    return os.environ.get('ZK_HOSTS').split(','), os.environ.get('ZK_PORT')


def call_or_nothing(callee):
    try:
        return callee()
    except Exception:
        logging.exception("failed")
        return []


def create_solomon_client(service):
    return reporter.create_solomon_reporter(
        oauth_token=conf.proto.Solomon.Token,
        url=conf.proto.Solomon.Url,
        project="crypta_audience",
        cluster=getoptpb.convert_env_enum_to_string(conf.proto.Environment),
        service=service,
    )


def get_cluster_name(cluster):
    return 'localhost' if cluster.startswith('localhost') else cluster.split('.')[0]


def main(args):
    for service, get_metrics in (
        ("metrics_audience", audience.metrics),
        ("metrics_lookalike", lookalike.metrics),
        ("metrics_yt", yt_usage.metrics),
    ):
        solomon_client = create_solomon_client(service)

        for cluster in yt_clusters():
            client = yt.YtClient(cluster, conf.proto.Yt.Token)
            metrics = call_or_nothing(lambda: get_metrics(client))

            for sensor, value in metrics:
                solomon_client.set_value(sensor, value, labels={"yt": get_cluster_name(cluster)})

    solomon_client = create_solomon_client("metrics_workflow")

    for sensor, value in call_or_nothing(lambda: workflow.metrics(*zk_hosts_and_port())):
        solomon_client.set_value(sensor, value)
