import crypta.lib.python.bt.workflow as workflow
from crypta.lib.python.zk import (
    zk_client,
)

import logging
logger = logging.getLogger(__name__)


ONLINE_WORKERS_ID = 'online_workers'
ENQUEUED_TASKS_ID = 'enqueued_tasks'


def metrics(zk_hosts, zk_port):
    with zk_client(hosts=zk_hosts, port=zk_port) as zk:
        workers = list(workflow.all_workers(zk))
        tasks = list(workflow.all_tasks(zk))
        logger.info('Online workers: %s', workers)
        logger.info('Enqueued tasks: %s', tasks)

        return [
            (ONLINE_WORKERS_ID, len(workers)),
            (ENQUEUED_TASKS_ID, len(tasks)),
        ]
