#!/bin/bash
CRYPTA_ENV=${CRYPTA_ENVIRONMENT:-testing}
TOTAL_ZOO_HOSTS=${TOTAL_ZOO_HOSTS:-5}
ZOO_CLIENT_PORT=${ZOO_CLIENT_PORT:-2181}

CONFIG_FILE="/etc/zookeeper/conf/zoo.cfg"
MYID_FILE="/var/lib/zookeeper/myid"

for i in $(seq 1 ${TOTAL_ZOO_HOSTS}); do
    host=$(host zoo${i}.${CRYPTA_ENV}.crypta.yandex.net. | grep alias | awk '{print $NF}')
    if [[ $host == ${DEPLOY_POD_PERSISTENT_FQDN}* ]]; then
        echo $i > ${MYID_FILE}
        break
    fi
done

cat > ${CONFIG_FILE} << EOF
tickTime=5000
dataDir=/var/lib/zookeeper
dataLogDir=/var/log/zookeeper
clientPort=${ZOO_CLIENT_PORT}
initLimit=5
syncLimit=3

myid_file=/var/lib/zookeeper/myid
config_file=/etc/zookeeper/conf/zoo.cfg

EOF

for i in $(seq 1 ${TOTAL_ZOO_HOSTS}); do
    echo "server.${i}=zoo${i}.${CRYPTA_ENV}.crypta.yandex.net:2888:3888" >> ${CONFIG_FILE}
done

/etc/init.d/zookeeper start

/juggler.py
