#include <crypta/audience/tools/learn_codec/config.pb.h>
#include <crypta/lib/native/cmd_args/parse_pb_options.h>

#include <library/cpp/codecs/static/builder.h>
#include <library/cpp/codecs/static/static_codec_info.pb.h>
#include <mapreduce/yt/interface/client.h>

using namespace NCrypta::NAudience;

int main(int argc, const char** argv) {
    const auto& config = NCrypta::ParsePbOptions<TConfig>(argc, argv);

    auto client = NYT::CreateClient(config.GetYt().GetProxy());

    TVector<TString> trainingData;
    trainingData.reserve(config.GetRowCount());
    auto reader = client->CreateTableReader<NYT::TNode>(config.GetPath());
    for (ui64 i = 0; reader->IsValid() && i < config.GetRowCount(); reader->Next(), ++i) {
        auto& row = reader->GetRow();
        trainingData.emplace_back(row["value"].AsString());
    }

    NCodecs::TCodecBuildInfo buildInfo{
        .CodecName = config.GetCodec(),
    };
    const auto& staticCodecInfo = NCodecs::BuildStaticCodec(trainingData, buildInfo);

    TFileOutput output(config.GetOutput());
    NCodecs::SaveCodecInfoToStream(output, staticCodecInfo);

    return 0;
}
