import yt.wrapper as yt
import os
import sys


def init_yt(proxy='hahn'):
    token = os.environ.get('YT_TOKEN')
    assert token is not None
    yt.config['token'] = token
    yt.config['proxy']['url'] = proxy
    return yt


def increase_input_priority(searched_segments):
    for segment in search_input_segments(yt, searched_segments):
        yt.set_attribute(segment, "segment_priority", 1000)


def search_batched_segments(yt, searched_segments):
    batches = []
    for batch in yt.list("//home/crypta/production/audience/batches", attributes=["crypta_meta"], max_size=None, absolute=True):
        segments = set(map(lambda x: str(x["audience_segment_id"]), batch.attributes["crypta_meta"]["segments"].values()))

        intersection = set(searched_segments).intersection(segments)
        if len(intersection):
            print intersection, batch
            batches.append(batch)
    return batches


def search_input_segments(yt, searched_segments):
    segments = []
    for segment in yt.list("//home/crypta/production/audience/io/regular/input", attributes=["segment_id", "segment_priority"], max_size=None, absolute=True):
        _id = str(segment.attributes.get("segment_id", ""))
        if _id in searched_segments:
            print _id, segment.attributes["segment_priority"], segment
            segments.append(segment)

    return segments


def search_output_segments(yt, searched_segments):
    segments = []
    for segment in yt.list("//home/crypta/production/audience/io/regular/output", attributes=["segment_id"], max_size=None, absolute=True):
        _id = str(segment.attributes.get("segment_id", ""))
        if _id in searched_segments:
            print _id,  segment
            segments.append(segment)
    return segments


def main():
    yt = init_yt()
    segments = []
    if len(sys.argv) > 1:
        segments = sys.argv[1:]

    segments = set(map(lambda segment: str(segment), segments))
    search_batched_segments(yt, segments)
    search_input_segments(yt, segments)
    search_output_segments(yt, segments)
