import argparse
import logging

from crypta.buchhalter.services.main.lib import (
    adfox_calc,
    audience_add_logins_to_segments,
    audience_dmp_report_calc,
    audience_filter_shared_chevents,
    audience_group_segments,
    audience_per_group_calc,
    audience_per_owner_calc,
    audience_per_segment_events_calc,
    audience_per_segment_login_metrics,
    audience_send_shadow_dmp_reports,
    audience_shadow_dmp_report_calc,
    audience_shadow_dmps_calc,
    backuper,
    direct_calc,
    display_calc,
    lookalike_calc,
    multipliers_calc,
)
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)

    subparsers = parser.add_subparsers()

    subtasks = [
        adfox_calc,
        audience_add_logins_to_segments,
        audience_dmp_report_calc,
        audience_filter_shared_chevents,
        audience_group_segments,
        audience_per_group_calc,
        audience_per_owner_calc,
        audience_per_segment_events_calc,
        audience_per_segment_login_metrics,
        audience_send_shadow_dmp_reports,
        audience_shadow_dmp_report_calc,
        audience_shadow_dmps_calc,
        backuper,
        direct_calc,
        display_calc,
        lookalike_calc,
        multipliers_calc,
    ]

    for subtask in subtasks:
        subtask.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger = logging.getLogger(__name__)

    args = parse_args()
    logger.info("Args: %s", args)

    config = yaml_config.parse_config(args.config_proto_cls, args.config)
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(config))

    function = args.function

    kwargs = vars(args)
    del kwargs["config"]
    del kwargs["config_proto_cls"]
    del kwargs["function"]

    function(config, logger, **kwargs)

    logger.info("Completed successfully")
