from crypta.buchhalter.services.main.lib.audience_add_logins_to_segments.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("audience_add_logins_to_segments", help="Add logins to Audience segments")
    parser.set_defaults(function=add_logins)
    parser.set_defaults(config_proto_cls=TConfig)


def add_logins(config, logger):
    params = {
        "segments_table_path": config.SegmentsTable,
        "puid_to_login_table_path": config.PuidToLoginTable,
        "segments_with_logins_table_path": config.SegmentsWithLoginsTable,
    }

    yql_helpers.run_query("/query/add_logins.yql", config.Yt, params, logger)
