import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.audience_filter_shared_chevents.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import path_utils
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("audience_filter_shared_chevents", help="Filter shared chevents for Yandex.Audience in Yandex.Direct")
    parser.set_defaults(function=filter_chevents)
    parser.set_defaults(config_proto_cls=TConfig)


def filter_chevents(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    tracker = ProcessedTablesTracker(config.FlattenedChevents)

    while True:
        with yt_client.Transaction() as tx:
            src_table_paths = tracker.get_unprocessed_tables(yt_client, 1)

            if not src_table_paths:
                logger.info("No tables to process")
                break

            flattened_chevents_table_path = src_table_paths[0]

            logger.info("Processing table %s", flattened_chevents_table_path)

            date = path_utils.get_basename(flattened_chevents_table_path)
            flattened_shared_chevents_table_path = ypath.ypath_join(config.FlattenedSharedCheventsDir, date)

            params = {
                "flattened_chevents_table_path": flattened_chevents_table_path,
                "flattened_shared_chevents_table_path": flattened_shared_chevents_table_path,
            }
            yql_helpers.run_query("/query/filter_chevents.yql", config.Yt, params, logger, tx=tx)

            yt_helpers.set_ttl_by_table_name(flattened_shared_chevents_table_path, datetime.timedelta(days=config.OutputTtlDays), yt_client)

            tracker.add_processed_tables(yt_client, [flattened_chevents_table_path])
