from crypta.buchhalter.services.main.lib.audience_group_segments import groups_helpers
from crypta.buchhalter.services.main.lib.audience_group_segments.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("audience_group_segments", help="Group Audience segments")
    parser.set_defaults(function=set_segment_groups)
    parser.set_defaults(config_proto_cls=TConfig)
    parser.add_argument("--dmp-index", required=True)
    parser.add_argument("--adobe-index", required=True)
    parser.add_argument("--shadow-dmp-index", required=True)
    parser.add_argument("--groups", required=True)


def set_segment_groups(config, logger, dmp_index, adobe_index, shadow_dmp_index, groups):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    with yt_client.Transaction() as tx:
        groups_helpers.write_to_login_groups_table(yt_client, config.LoginGroupsTable, dmp_index, adobe_index, shadow_dmp_index, groups)

        params = {
            "login_groups_table_path": config.LoginGroupsTable,
            "segments_with_logins_table_path": config.SegmentsWithLoginsTable,
            "segment_groups_table_path": config.SegmentGroupsTable,
        }

        yql_helpers.run_query("/query/set_segment_groups.yql", config.Yt, params, logger, tx=tx)
