import itertools

from google.protobuf import json_format
import yaml

from crypta.buchhalter.services.main.lib.common.helpers import indexes
from crypta.buchhalter.services.main.lib.common.proto.login_group_pb2 import TLoginGroup
from crypta.lib.python.yt import schema_utils


def get_groups_from_indexes(dmp_index_filename, adobe_index_filename, shadow_dmp_index_filename):
    groups_logins = {
        "dmp": indexes.get_dmp_logins(dmp_index_filename),
        "adobe": indexes.get_adobe_logins(adobe_index_filename),
        "shadow_dmps_with_reports": indexes.get_shadow_dmp_logins(shadow_dmp_index_filename),
    }

    for group, logins in groups_logins.iteritems():
        for login in logins:
            yield TLoginGroup(Group=group, Login=login)


def get_groups_from_config(groups_filename):
    with open(groups_filename) as groups_file:
        groups = yaml.safe_load(groups_file)
        if groups is not None:
            for item in groups:
                for login in item["logins"]:
                    yield TLoginGroup(Group=item["group"], Login=login)


def get_login_groups(dmp_index_filename, adobe_index_filename, shadow_dmp_index_filename, groups_filename):
    return itertools.chain(get_groups_from_indexes(dmp_index_filename, adobe_index_filename, shadow_dmp_index_filename), get_groups_from_config(groups_filename))


def write_to_login_groups_table(yt_client, table_path, dmp_index_filename, adobe_index_filename, shadow_dmp_index_filename, groups_filename):
    yt_client.create("table", table_path, attributes={"schema": schema_utils.get_schema_from_proto(TLoginGroup)}, force=True, recursive=True)
    yt_client.write_table(table_path, [json_format.MessageToDict(item) for item in get_login_groups(dmp_index_filename, adobe_index_filename, shadow_dmp_index_filename, groups_filename)])
