import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.audience_per_group_calc.config_pb2 import TConfig
from crypta.buchhalter.services.main.lib.common import stats
from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("audience_per_group_calc", help="Calc per group stats in Yandex.Direct")
    parser.set_defaults(function=calc_group_stats)
    parser.set_defaults(config_proto_cls=TConfig)


def calc_group_stats(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    tracker = ProcessedTablesTracker(config.TargetingFlattenedSharedChevents)

    while True:
        with yt_client.Transaction() as tx:
            date = tables_helpers.get_unprocessed_date(yt_client, tracker, [config.MultipliersFlattenedSharedCheventsDir], logger)
            if date is None:
                break

            targeting_flattened_shared_chevents_table_path = ypath.ypath_join(config.TargetingFlattenedSharedChevents.SourceDir, date)
            multipliers_flattened_shared_chevents_table_path = ypath.ypath_join(config.MultipliersFlattenedSharedCheventsDir, date)

            logger.info("Processing tables %s and %s", targeting_flattened_shared_chevents_table_path, multipliers_flattened_shared_chevents_table_path)

            targeting_group_stats_table_path = ypath.ypath_join(config.TargetingGroupStatsDir, date)
            multipliers_group_stats_table_path = ypath.ypath_join(config.MultipliersGroupStatsDir, date)
            total_group_stats_table_path = ypath.ypath_join(config.TotalGroupStatsDir, date)

            params = {
                "targeting_flattened_shared_chevents_table_path": targeting_flattened_shared_chevents_table_path,
                "multipliers_flattened_shared_chevents_table_path": multipliers_flattened_shared_chevents_table_path,
                "segment_groups_dir": config.SegmentGroupsDir,
                "targeting_group_stats_table_path": targeting_group_stats_table_path,
                "multipliers_group_stats_table_path": multipliers_group_stats_table_path,
                "total_group_stats_table_path": total_group_stats_table_path,
                "stats": stats.get_stats_query(),
                "serialize_selecttype_func": stats.SERIALIZE_SELECTTYPE,
            }

            yql_helpers.run_query("/query/calc_stats.yql", config.Yt, params, logger, tx=tx)

            ttl_timedelta = datetime.timedelta(days=config.OutputTtlDays)
            for table_path in (targeting_group_stats_table_path, multipliers_group_stats_table_path, total_group_stats_table_path):
                yt_helpers.set_ttl_by_table_name(table_path, ttl_timedelta, yt_client)

            tracker.add_processed_tables(yt_client, [targeting_flattened_shared_chevents_table_path])
