import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.audience_per_segment_events_calc.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import path_utils
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("audience_per_segment_events_calc", help="Calc Audience per segment events in Yandex.Direct")
    parser.set_defaults(function=calc_per_segment_events)
    parser.set_defaults(config_proto_cls=TConfig)


def calc_per_segment_events(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    tracker = ProcessedTablesTracker(config.RetargetingChevents)

    while True:
        with yt_client.Transaction() as tx:
            src_table_paths = tracker.get_unprocessed_tables(yt_client, 1)

            if not src_table_paths:
                logger.info("No tables to process")
                break

            retargeting_chevents_table_path = src_table_paths[0]

            logger.info("Processing table %s", retargeting_chevents_table_path)

            date = path_utils.get_basename(retargeting_chevents_table_path)
            audience_per_segment_events_table_path = ypath.ypath_join(config.SegmentCheventsDir, date)

            params = {
                "retargeting_chevents_table_path": retargeting_chevents_table_path,
                "segments_with_logins_table_path": config.SegmentsWithLoginsTable,
                "direct_campaigns_table_path": config.DirectCampaignsTable,
                "direct_users_table_path": config.DirectUsersTable,
                "direct_clients_table_path": config.DirectClientsTable,
                "audience_per_segment_events_table_path": audience_per_segment_events_table_path,
            }

            yql_helpers.run_query("/query/calc_per_segment_events.yql", config.Yt, params, logger, tx=tx)

            ttl_timedelta = datetime.timedelta(days=config.OutputTtlDays)
            yt_helpers.set_ttl_by_table_name(audience_per_segment_events_table_path, ttl_timedelta, yt_client)

            tracker.add_processed_tables(yt_client, [retargeting_chevents_table_path])
