import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.backuper.config_pb2 import TConfig
from crypta.lib.python import time_utils
from crypta.lib.python.yql import (
    client as yql,
    yql_helpers,
)
from crypta.lib.python.yt import yt_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("backuper", help="Backup Direct and Yabs tables daily")
    parser.set_defaults(function=run)
    parser.set_defaults(config_proto_cls=TConfig)


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    date = time_utils.get_current_moscow_datetime().strftime("%Y-%m-%d")

    logger.info("Current date: %s", date)

    output_goal_context_table = ypath.ypath_join(config.OutputGoalContextDir, date)
    output_multipliers_table = ypath.ypath_join(config.OutputMultipliersDir, date)
    output_retargeting_goals_table = ypath.ypath_join(config.OutputRetargetingGoalsDir, date)
    output_campaign_logins_table = ypath.ypath_join(config.OutputCampaignLoginsDir, date)

    params = {
        "direct_campaigns_table": config.DirectCampaignsTable,
        "direct_clients_table": config.DirectClientsTable,
        "direct_users_table": config.DirectUsersTable,
        "direct_hierarchical_multipliers_table": config.DirectHierarchialMultipliersTable,
        "direct_retargeting_goals_table": config.DirectRetargetingGoalsTable,
        "goal_context_table": config.GoalContextTable,

        "output_goal_context_table": output_goal_context_table,
        "output_multipliers_table": output_multipliers_table,
        "output_retargeting_goals_table": output_retargeting_goals_table,
        "output_campaign_logins_table": output_campaign_logins_table,
    }

    with yt_client.Transaction() as tx:
        yql_helpers.run_query(
            "/query/backup.yql",
            config.Yt,
            params,
            logger,
            tx=tx,
            udfs=[yql.Udf("bigb.so", config.BigbUdfUrl)],
        )

        ttl_timedelta = datetime.timedelta(days=config.OutputTtlDays)
        for table_path in (output_goal_context_table, output_multipliers_table, output_retargeting_goals_table, output_campaign_logins_table):
            yt_helpers.set_ttl_by_table_name(table_path, ttl_timedelta, yt_client)
