import yaml

from crypta.buchhalter.services.main.lib.common.proto.shadow_dmp_index_pb2 import TShadowDmpIndex
from crypta.lib.python import (
    templater,
    yaml2proto,
)


def get_logins(index):
    return [
        item["audience_login"]
        for item in index
        if not item.get("internal")
    ]


def get_dmp_logins(dmp_index_filename):
    with open(dmp_index_filename) as dmp_index_file:
        return get_logins(yaml.safe_load(templater.render_template(dmp_index_file.read(), vars={"environment": "stable"}, strict=True)))


def get_adobe_logins(adobe_index_filename):
    with open(adobe_index_filename) as adobe_index_file:
        return get_logins(yaml.safe_load(adobe_index_file))


def get_shadow_dmp_index(shadow_dmp_index_filename):
    with open(shadow_dmp_index_filename) as f:
        return yaml2proto.yaml2protos(f.read(), TShadowDmpIndex)


def get_shadow_dmp_logins(shadow_dmp_index_filename):
    return [item.AudienceLogin for item in get_shadow_dmp_index(shadow_dmp_index_filename)]


def get_audience_logins(yt_client, dmp_index_table):
    return [
        item["audience_login"]
        for item in yt_client.read_table(dmp_index_table)
        if not item.get("internal")
    ]
