import calendar
import collections
import datetime

import six

from crypta.lib.python.yt import path_utils


MonthPaths = collections.namedtuple("MonthPaths", ["year", "month", "paths"])


def get_full_months(paths):
    groups = collections.defaultdict(list)
    for path in paths:
        dt = datetime.datetime.strptime(path_utils.get_basename(path), "%Y-%m-%d")
        groups[(dt.year, dt.month)].append(path)

    result = []
    for k, v in six.iteritems(groups):
        year, month = k
        _, number_of_days_in_month = calendar.monthrange(year, month)

        if len(v) == number_of_days_in_month:
            result.append(MonthPaths(year=year, month=month, paths=sorted(v)))

    return sorted(result, key=lambda x: (-x.year, -x.month))
