# TODO(kolontaev): Унести модуль в crypta/lib/python/yt, т.к. он используется за пределами бухгалтера
from crypta.lib.python.yt import path_utils


def _get_date(unprocessed_table_paths, extra_dates):
    for unprocessed_table_path in unprocessed_table_paths:
        date = path_utils.get_basename(unprocessed_table_path)

        if all(date in dates for dates in extra_dates):
            return date

    return None


def get_unprocessed_date(yt_client, tracker, extra_dirs, logger, extra_dates=None):
    unprocessed_table_paths = tracker.get_unprocessed_tables(yt_client)
    logger.info("Unprocessed tables %s", unprocessed_table_paths)

    if not unprocessed_table_paths:
        logger.info("No tables to process")
        return None

    full_extra_dates = [set(yt_client.list(x)) for x in extra_dirs] + [set(x) for x in (extra_dates or [])]
    date = _get_date(unprocessed_table_paths, full_extra_dates)

    if date is None:
        logger.info("No date found. Extra dirs = %s", extra_dirs)

    return date


def unprocessed_dates(yt_client, tracker, extra_dirs, logger):
    while True:
        with yt_client.Transaction() as tx:
            date = get_unprocessed_date(yt_client, tracker, extra_dirs, logger)

            if date is None:
                logger.info("No date to process")
                return

            yield tx, date
