from library.python.protobuf.json import proto2json
import yt.wrapper as yt

from crypta.buchhalter.services.main.lib.common.join_acl.segment_acl_pb2 import TSegmentAcl
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import schema_utils


def run(audience_client, yt_config, yt_client, tx, input_table_path, output_table_path, logger):
    acls_table_attributes = {"schema": schema_utils.get_schema_from_proto(TSegmentAcl)}

    def tmp_table(attributes=None):
        return yt.TempTable(yt_config.TmpDir, attributes=attributes, client=yt_client)

    with tmp_table() as distinct_segment_ids_table_path, tmp_table(acls_table_attributes) as acls_table_path:
        get_distinct_segment_ids(yt_config, tx, input_table_path, distinct_segment_ids_table_path, logger)
        get_acls(audience_client, yt_client, distinct_segment_ids_table_path, acls_table_path, logger)
        join_acl(yt_config, tx, input_table_path, acls_table_path, output_table_path, logger)


def get_distinct_segment_ids(yt_config, tx, input_table_path, output_table_path, logger):
    params = {
        "input_table_path": input_table_path,
        "output_table_path": output_table_path,
    }
    yql_helpers.run_query("/query/get_distinct_segment_ids.yql", yt_config, params, logger, tx=tx)


def get_acls(audience_client, yt_client, distinct_segment_ids_table_path, output_table_path, logger):
    logger.info("Get acls from Audience API")
    distinct_segment_ids = (row["segmentid"] for row in yt_client.read_table(distinct_segment_ids_table_path))
    acls = (TSegmentAcl(SegmentId=segment_id, Acl=audience_client.list_grants_users(segment_id)) for segment_id in distinct_segment_ids)
    cfg = proto2json.Proto2JsonConfig(missing_repeated_key_mode=proto2json.MissingKeyDefault)
    yt_client.write_table(output_table_path, (proto2json.proto2json(x, cfg) for x in acls), format=yt.JsonFormat(attributes={"encode_utf8": False}), raw=True)


def join_acl(yt_config, tx, input_table_path, acls_table_path, output_table_path, logger):
    params = {
        "input_table_path": input_table_path,
        "acls_table_path": acls_table_path,
        "output_table_path": output_table_path,
    }
    yql_helpers.run_query("/query/join_acl.yql", yt_config, params, logger, tx=tx)
