from email.mime.application import MIMEApplication

from crypta.buchhalter.services.main.lib.common import report_generator


ATTACHMENT_FILENAME_TEMPLATE = "{login}_{date}.xlsx"
EMPTY_REPORT_TEXT = "There are no shows and clicks for your segments within the given period."
XLSX_MIME_SUBTYPE = "vnd.openxmlformats-officedocument.spreadsheetml.sheet"


def send(mail_sender, yt_client, cypress_path, date, login, settings):
    is_report_empty = report_generator.is_report_empty(cypress_path, yt_client)
    data = yt_client.read_file(cypress_path).read()
    date_string = date.strftime(settings.date_format)
    subject = settings.subject_template.format(login=login, date=date_string)
    text = EMPTY_REPORT_TEXT if is_report_empty else ""
    attachments = []

    if not is_report_empty:
        attachment_filename = ATTACHMENT_FILENAME_TEMPLATE.format(login=login, date=date_string)
        attachment = MIMEApplication(data, XLSX_MIME_SUBTYPE)
        attachment.add_header("Content-Disposition", "attachment", filename=attachment_filename)
        attachments.append(attachment)

    mail_sender.send(subject, text=text, attachments=attachments)
