CORE_STATS = """
    COUNT_IF({table_prefix}action_type == "show") AS shows,
    COUNT_IF({table_prefix}action_type == "click") AS clicks,
    SUM({table_prefix}cost) AS total_cost,
    COUNT(DISTINCT {table_prefix}orderid) AS campaigns_count
"""

STATS = CORE_STATS + \
""",
    SUM_IF({table_prefix}cost, {table_prefix}action_type == "show") ?? 0 AS shows_total_cost,
    SUM_IF({table_prefix}cost, {table_prefix}action_type == "click") ?? 0 AS clicks_total_cost,
    IF(COUNT_IF({table_prefix}action_type == "show") != 0, \
100.0 * COUNT_IF({table_prefix}action_type == "click") / COUNT_IF({table_prefix}action_type == "show"), 0) AS ctr,
    IF(COUNT_IF({table_prefix}action_type == "show") != 0, \
1000.0 * CAST(SUM_IF({table_prefix}cost, {table_prefix}action_type == "show") AS Double) / COUNT_IF({table_prefix}action_type == 'show'), 0) AS cpm,
    IF(COUNT_IF({table_prefix}action_type == "click") != 0, \
CAST(SUM_IF({table_prefix}cost, {table_prefix}action_type == "click") AS Double) / COUNT_IF({table_prefix}action_type == "click"), 0) AS cpc
"""

SERIALIZE_SELECTTYPE = """
$serialize_selecttype = ($selecttype) -> {
    RETURN IF(
        $selecttype == 5,
        "search",
        "rsya"
 )
}
"""

SERIALIZE_PLACEID = """
$serialize_placeid = ($placeid) -> {
    RETURN CASE
        WHEN $placeid == 542 THEN "perfomance"
        WHEN $placeid == 1542 THEN "display"
    ELSE ""
    END
}
"""

TO_ACTION_TYPE = """
$to_action_type = ($countertype) -> {
    RETURN CASE
        WHEN $countertype == 1 THEN "show"
        WHEN $countertype == 2 THEN "click"
        ELSE NULL
    END
}
"""

TO_RUBLES = """
$to_rubles = ($x) -> {
    RETURN CAST($x AS Double) * 30 / 1e6 / 1.18
}
"""

IS_VALID_PLACEID = """
$is_valid_placeid = ($placeid) -> {
    RETURN $placeid IN (542, 1542)
}
"""


def _get_stats_query(query, table_name=None):
    return query.format(table_prefix="{}.".format(table_name) if table_name else "")


def get_stats_query(table_name=None):
    return _get_stats_query(STATS, table_name)


def get_core_stats_query(table_name=None):
    return _get_stats_query(CORE_STATS, table_name)
