from crypta.buchhalter.services.main.lib.display_calc.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("display_calc", help="Calculate display stats")
    parser.set_defaults(function=calc_stats)
    parser.set_defaults(config_proto_cls=TConfig)


def calc_stats(config, logger):
    params = {
        "comdep_schedule_stats_table_path": config.ComdepScheduleStatsTable,
        "ado_schedules_table_path": config.AdoSchedulesTable,
        "ado_line_parameters_table_path": config.AdoLineParametersTable,
        "ado_audience_segments_table_path": config.AdoAudienceSegmentsTable,
        "segment_owners_table_path": config.SegmentOwnersTable,
        "segment_groups_dir": config.SegmentGroupsDir,
        "per_owner_stats_table_path": config.PerOwnerStatsTable,
        "top_owners_stats_table_path": config.TopOwnersStatsTable,
        "per_segment_stats_table_path": config.PerSegmentStatsTable,
        "per_group_table_path": config.PerGroupTable,
        "top_owners_threshold": config.TopOwnersThreshold,
    }

    yql_helpers.run_query("/query/calc_display_stats.yql", config.Yt, params, logger)
