import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.common import stats
from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.buchhalter.services.main.lib.lookalike_calc.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("lookalike_calc", help="Calc lookalike segments stats in Yandex.Direct")
    parser.set_defaults(function=calc_stats)
    parser.set_defaults(config_proto_cls=TConfig)


def calc_stats(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    tracker = ProcessedTablesTracker(config.TargetingChevents)

    while True:
        with yt_client.Transaction() as tx:
            date = tables_helpers.get_unprocessed_date(yt_client, tracker, [config.MultipliersCheventsDir], logger)
            if date is None:
                break

            targeting_chevents_table_path = ypath.ypath_join(config.TargetingChevents.SourceDir, date)
            multipliers_chevents_table_path = ypath.ypath_join(config.MultipliersCheventsDir, date)
            logger.info("Processing table %s and %s", targeting_chevents_table_path, multipliers_chevents_table_path)

            targeting_stats_table_path = ypath.ypath_join(config.TargetingStatsDir, date)
            multipliers_stats_table_path = ypath.ypath_join(config.MultipliersStatsDir, date)
            total_stats_table_path = ypath.ypath_join(config.TotalStatsDir, date)

            params = {
                "targeting_chevents_table_path": targeting_chevents_table_path,
                "multipliers_chevents_table_path": multipliers_chevents_table_path,

                "targeting_stats_table_path": targeting_stats_table_path,
                "multipliers_stats_table_path": multipliers_stats_table_path,
                "total_stats_table_path": total_stats_table_path,

                "serialize_selecttype_func": stats.SERIALIZE_SELECTTYPE,
                "serialize_placeid_func": stats.SERIALIZE_PLACEID,
                "stats": stats.get_stats_query(),
            }

            yql_helpers.run_query("/query/calc_lookalike_stats.yql", config.Yt, params, logger, tx=tx)

            ttl_datetime = datetime.timedelta(days=config.OutputTtlDays)
            for table_path in (targeting_stats_table_path, multipliers_stats_table_path, total_stats_table_path):
                yt_helpers.set_ttl_by_table_name(table_path, ttl_datetime, yt_client)

            tracker.add_processed_tables(yt_client, [targeting_chevents_table_path])
