import datetime

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.common import stats
from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.buchhalter.services.main.lib.multipliers_calc.config_pb2 import TConfig
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("multipliers_calc", help="Calc multipliers statistics in Yandex.Direct")
    parser.set_defaults(function=run)
    parser.set_defaults(config_proto_cls=TConfig)


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.CheventLog)

    while True:
        with yt_client.Transaction() as tx:
            date = tables_helpers.get_unprocessed_date(yt_client, tracker, [config.ActionCheckedLogDir, config.MultipliersDir, config.RetargetingGoalsDir, config.CampaignLoginsDir], logger)
            if date is None:
                break

            logger.info("Processing date %s", date)
            chevent_log_table_path = ypath.ypath_join(config.CheventLog.SourceDir, date)

            output_retargeting_id_chevents_table_path = ypath.ypath_join(config.OutputRetargetingIdCheventsDir, date)
            output_retargeting_id_stats_table_path = ypath.ypath_join(config.OutputRetargetingIdStatsDir, date)
            output_flattened_audience_segment_chevents_table_path = ypath.ypath_join(config.OutputFlattenedAudienceSegmentCheventsDir, date)
            output_shared_flattened_audience_segment_chevents_table_path = ypath.ypath_join(config.OutputSharedFlattenedAudienceSegmentCheventsDir, date)

            params = {
                "chevent_log_table_path": chevent_log_table_path,
                "action_log_table_path": ypath.ypath_join(config.ActionCheckedLogDir, date),
                "audience_segments_table_path": config.AudienceSegmentsTable,

                "multipliers_table_path": ypath.ypath_join(config.MultipliersDir, date),
                "retargeting_goals_table_path": ypath.ypath_join(config.RetargetingGoalsDir, date),
                "campaign_logins_table_path": ypath.ypath_join(config.CampaignLoginsDir, date),

                "output_retargeting_id_chevents_table_path": output_retargeting_id_chevents_table_path,
                "output_retargeting_id_stats_table_path": output_retargeting_id_stats_table_path,

                "output_flattened_audience_segment_chevents_table_path": output_flattened_audience_segment_chevents_table_path,
                "output_shared_flattened_audience_segment_chevents_table_path": output_shared_flattened_audience_segment_chevents_table_path,

                "serialize_selecttype_func": stats.SERIALIZE_SELECTTYPE,
                "serialize_placeid_func": stats.SERIALIZE_PLACEID,
                "to_action_type_func": stats.TO_ACTION_TYPE,
                "to_rubles_func": stats.TO_RUBLES,
                "is_valid_placeid_func": stats.IS_VALID_PLACEID,
                "stats": stats.get_core_stats_query(),
            }

            yql_helpers.run_query("/query/multipliers_calc.yql", config.Yt, params, logger, tx=tx)

            ttl_timedelta = datetime.timedelta(days=config.OutputTtlDays)
            for table_path in (
                output_retargeting_id_chevents_table_path,
                output_retargeting_id_stats_table_path,
                output_flattened_audience_segment_chevents_table_path,
                output_shared_flattened_audience_segment_chevents_table_path,
            ):
                yt_helpers.set_ttl_by_table_name(table_path, ttl_timedelta, yt_client)

            tracker.add_processed_tables(yt_client, [chevent_log_table_path])
