#include "match_fields.h"
#include "match_schema.h"

using namespace NCrypta::NOfflineCm::NMatchFields;

NYT::TTableSchema NCrypta::NOfflineCm::GetUnsortedMatchSchema() {
    return NYT::TTableSchema()
        .AddColumn(NYT::TColumnSchema().Name(EXT_ID).Type(NYT::VT_STRING, /*required*/ true))
        .AddColumn(NYT::TColumnSchema().Name(TIMESTAMP).Type(NYT::VT_UINT64, /*required*/ true))
        .AddColumn(NYT::TColumnSchema().Name(YANDEXUID).Type(NYT::VT_STRING, /*required*/ true))
        .AddColumn(NYT::TColumnSchema().Name(TAG).Type(NYT::VT_STRING, /*required*/ true))
        .Strict(true);
}

NYT::TTableSchema NCrypta::NOfflineCm::GetMatchSchema() {
    auto schema = GetUnsortedMatchSchema();
    schema.MutableColumns().at(0).SortOrder(NYT::SO_ASCENDING);
    return schema;
}

NYT::TTableSchema NCrypta::NOfflineCm::GetMatchSchemaWithUniqueKeys() {
    auto schema = GetMatchSchema();
    schema.MutableColumns().at(1).SortOrder(NYT::SO_ASCENDING);
    schema.UniqueKeys(true);
    return schema;
}
