from yt import yson


TAG = "tag"
TIMESTAMP = "timestamp"
EXT_ID = "ext_id"
YANDEXUID = "yuid"


def get_unsorted_schema():
    schema = yson.YsonList([
        dict(name=EXT_ID, type="string", required=True),
        dict(name=TIMESTAMP, type="uint64", required=True),
        dict(name=YANDEXUID, type="string", required=True),
        dict(name=TAG, type="string", required=True)
    ])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_schema():
    schema = get_unsorted_schema()
    schema[0]["sort_order"] = "ascending"
    return schema


def get_schema_with_unique_keys():
    schema = get_schema()
    schema[1]["sort_order"] = "ascending"
    schema.attributes["unique_keys"] = True
    return schema
