#include <crypta/cm/offline/bin/common/config_fields.h>
#include <crypta/cm/offline/bin/parse_cm_access_log/lib/parse_cm_access_log_job.h>
#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>
#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NCrypta::NOfflineCm;

namespace {
    TParseCmAccessLogJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TParseCmAccessLogJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.SourceDir = yaml[CM_ACCESS_LOG_DIR].as<NYT::TYPath>();
        config.DestinationDir = yaml[FRESH_CM_DIR].as<NYT::TYPath>();
        config.TrackTable = yaml[CM_ACCESS_LOG_TRACK_TABLE].as<NYT::TYPath>();
        config.TablePackSize = yaml[TABLE_PACK_SIZE].as<size_t>();
        config.ErrorsDir = yaml[CM_ACCESS_LOG_PARSER_ERRORS_DIR].as<NYT::TYPath>();
        config.ErrorsTtlDays = yaml[ERRORS_TTL_DAYS].as<ui64>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TParseCmAccessLogJob, ParseConfig>(argc, argv);
}
