#pragma once

#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/client.h>


namespace NCrypta::NOfflineCm {
    class TParseCmAccessLogJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;
            NYT::TYPath SourceDir;
            NYT::TYPath DestinationDir;
            NYT::TYPath TrackTable;
            NYT::TYPath ErrorsDir;
            size_t TablePackSize = 0;
            ui64 ErrorsTtlDays = 0;
        };

        explicit TParseCmAccessLogJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
