#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NOfflineCm {
    class TParseCmAccessLogMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EOutputTables {
            Matches,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TParseCmAccessLogMapper() = default;
        TParseCmAccessLogMapper(const TOutputIndexes& outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        TOutputIndexes OutputIndexes;
    };
}
