#include <crypta/cm/offline/bin/common/config_fields.h>
#include <crypta/cm/offline/bin/split_by_tag/lib/split_by_tag_job.h>
#include <crypta/lib/native/yaml/parse_yaml_file.h>
#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/yaml/as/tstring.h>

#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NOfflineCm;

namespace {
    THashMap<TString, NYT::TYPath> ParseDestinationDirs(const YAML::Node& yaml) {
        using namespace NOfflineCm::NConfigFields;

        THashMap<TString, NYT::TYPath> result;
        THashSet<NYT::TYPath> dirs;

        for (const auto& elem: yaml) {
            const auto& tag = elem[TAG].as<TString>();
            const auto& dir = elem[TAG_FRESH_DIR].as<NYT::TYPath>();
            Y_ENSURE(!dir.empty(), "Path for tag '" << tag << "' is empty");

            const auto& [dirIt, dirInserted] = dirs.insert(dir);
            Y_ENSURE(dirInserted, "fresh dir '" << dir << "' mentioned in tags at least twice");

            const auto& [tagIt, tagInserted] = result.insert({tag, dir});
            Y_ENSURE(tagInserted, "Tag '" << tag << "' mentioned in tags at least twice");
        }

        return result;
    }

    TSplitByTagJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TSplitByTagJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.SourceDir = yaml[FRESH_CM_DIR].as<NYT::TYPath>();
        config.DestinationDirs = ParseDestinationDirs(yaml[TAGS]);
        config.TablePackSize = yaml[TABLE_PACK_SIZE].as<size_t>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TSplitByTagJob, ParseConfig>(argc, argv);
}
