#pragma once

#include <crypta/lib/native/log/log.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NOfflineCm {
    class TSplitByTagJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;
            NYT::TYPath SourceDir;
            THashMap<TString, NYT::TYPath> DestinationDirs;
            size_t TablePackSize = 0;
            bool ShouldDropInput = false;
        };

        explicit TSplitByTagJob(const TConfig& config, NLog::TLogPtr log);

        int Do();

    private:
        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
