#include "split_by_tag_mapper.h"

#include <crypta/cm/offline/bin/common/match_fields.h>


using namespace NCrypta::NOfflineCm;
using namespace NMatchFields;

TSplitByTagMapper::TSplitByTagMapper(const TOutputIndexes& outputIndexes)
    : OutputIndexes(outputIndexes)
{
}

void TSplitByTagMapper::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        const auto& tag = row.At(TAG).AsString();
        const auto& index = OutputIndexes[tag];

        if (index.Defined()) {
            writer->AddRow(row, *index);
        }
    }
}

REGISTER_MAPPER(TSplitByTagMapper);
