#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NOfflineCm {
    class TSplitByTagMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        using TOutputIndexes = TTablesIndexes<TString>;

        TSplitByTagMapper() = default;
        TSplitByTagMapper(const TOutputIndexes& outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        TOutputIndexes OutputIndexes;
    };
}
