#include <crypta/cm/offline/bin/common/config_fields.h>
#include <crypta/cm/offline/bin/update_state/lib/update_state_job.h>
#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;
using namespace NOfflineCm;

namespace {
    TUpdateStateJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TUpdateStateJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.SourceDir = yaml[TAG_FRESH_DIR].as<NYT::TYPath>();
        config.DestinationTable = yaml[TAG_STATE_TABLE].as<NYT::TYPath>();
        config.TablePackSize = yaml[TABLE_PACK_SIZE].as<size_t>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();
        config.Ttl = yaml[TTL].as<ui64>();

        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TUpdateStateJob, ParseConfig>(argc, argv);
}
