#include "update_state_reducer.h"

#include <crypta/cm/offline/bin/common/match_fields.h>

using namespace NCrypta::NOfflineCm;
using namespace NMatchFields;

TUpdateStateReducer::TUpdateStateReducer(ui64 ttl)
    : Ttl(ttl)
{
}

void TUpdateStateReducer::Do(TReader* reader, TWriter* writer) {
    NYT::TNode result;

    for (; reader->IsValid(); reader->Next()) {
        result = reader->GetRow();
    }

    if (!Ttl.IsExpired(result.At(TIMESTAMP).AsUint64())) {
        writer->AddRow(result);
    }
}

REGISTER_REDUCER(TUpdateStateReducer);
