#include "ext_id_processor.h"

#include <crypta/cm/services/api/lib/logic/common/ext_id_request/ext_id_request_parser.h>
#include <crypta/cm/services/common/data/id_utils.h>
#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/cm/services/common/serializers/id/string/id_string_serializer.h>
#include <crypta/lib/native/singleton/tagged_singleton.h>
#include <crypta/lib/native/time/scope_timer.h>

#include <util/string/builder.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NApi;

TExtIdProcessor::TExtIdProcessor(
    const TString& handleName,
    NYtDynTables::TKvDatabase& replicaDatabase,
    TMutationSender& mutationSender,
    TStats& stats)
    : TRequestProcessor(NCrypta::NLog::GetLog(handleName), stats)
    , MutationSender(mutationSender)
    , HandleName(handleName)
    , ReplicaDatabase(replicaDatabase)
{
}

void TExtIdProcessor::DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) {
    TScopeTimer scopeTimer(Stats.Percentile, "timing.process");

    Stats.Count->Add("request.total.received");
    Stats.Count->Add("tvm_client." + clientInfo.GetName());

    TExtIdRequest request;
    try {
        request = NExtIdRequestParser::Parse(TCgiParameters(reply.GetRequestCgi()));
    } catch (const yexception& e) {
        SendResponse(reply, HTTP_BAD_REQUEST, e.what());
        return;
    }

    Stats.Count->Add("client." + clientInfo.GetName() + "." + request.Subclient);

    const auto& requestedId = request.Id;

    Y_ENSURE(!IsInternalId(requestedId), "Can not " << HandleName << " internal id: " << NIdSerializer::ToString(requestedId));

    const THashSet<TString> trackedBackRefTags;
    const auto dbState = TDbStateLoader(Log, trackedBackRefTags).Load(ReplicaDatabase, {requestedId}, false, false);

    const auto* match = dbState.GetMatches().Get(requestedId);
    if (!match) {
        SendResponse(reply, HTTP_NOT_FOUND, ::TStringBuilder() << "Nothing found for id " << NIdSerializer::ToString(requestedId));
        return;
    }

    ProcessMatch(*match);

    SendResponse(reply, HTTP_OK, "Scheduled for " + HandleName);
}
