#pragma once

#include <crypta/cm/services/api/lib/logic/common/mutation_sender.h>
#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/common/data/match.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

namespace NCrypta::NCm::NApi {
    class TExtIdProcessor : public TRequestProcessor {
    public:
        TExtIdProcessor(
            const TString& handleName,
            NYtDynTables::TKvDatabase& replicaDatabase,
            TMutationSender& mutationSender,
            TStats& stats);
        ~TExtIdProcessor() override = default;

    protected:
        virtual void ProcessMatch(const NCrypta::NCm::TMatch& match) = 0;

        TMutationSender& MutationSender;

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;

        const TString HandleName;
        NYtDynTables::TKvDatabase& ReplicaDatabase;
    };
}
