#pragma once

#include <crypta/cm/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>

#include <library/cpp/http/misc/httpcodes.h>

namespace NCrypta::NCm::NApi {
    class IRequestProcessor: TMoveOnly {
    public:
        // Processes request and sends reply. Reply is either 200 OK or 404/500.
        // Can throw exceptions, but exceptions are should be treated as unexpected.
        // Caller must check for reply.IsReplied() before reporting about any exception.
        virtual void Process(NHttp::TRequestReply& reply, const TClient& clientInfo) = 0;
        virtual ~IRequestProcessor() = default;
    };

    class TRequestProcessor : public IRequestProcessor {
    public:
        explicit TRequestProcessor(NLog::TLogPtr log, TStats& stats);
        ~TRequestProcessor() override = default;

        void Process(NHttp::TRequestReply& reply, const TClient& clientInfo) final;

    protected:
        virtual void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) = 0;
        void SendResponse(NHttp::TRequestReply& reply, HttpCodes httpCode, const TString& response);
        void SendInternalError(NHttp::TRequestReply& reply, const TString& error);

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
