#include "expire_processor.h"

#include <crypta/lib/native/singleton/tagged_singleton.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NApi;

const char* const HANDLE_NAME = "expire";

TExpireProcessor::TExpireProcessor(NYtDynTables::TKvDatabase& replicaDatabase, TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TExtIdProcessor(HANDLE_NAME,
                      replicaDatabase,
                      mutationSender,
                      TaggedSingleton<TStats, decltype(*this)>(HANDLE_NAME, statsSettings))
{
}

void TExpireProcessor::ProcessMatch(const NCrypta::NCm::TMatch& match) {
    MutationSender.ExpireMatch(match);
}
