#pragma once

#include <crypta/cm/services/api/lib/logic/common/request_processor.h>
#include <crypta/cm/services/api/lib/logic/identify/turbo_decryptor.h>
#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/cm/services/common/data/match.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <util/generic/vector.h>

namespace NCrypta::NCm::NApi {
    class TIdentifyProcessor : public TRequestProcessor {
    public:
        TIdentifyProcessor(
                NYtDynTables::TKvDatabase& replicaDatabase,
                const TStats::TSettings& statsSettings,
                const TTurboDecryptor& turboDecryptor);
        ~TIdentifyProcessor() override = default;

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;

        void RespondOnNotFound(NHttp::TRequestReply& reply, const TDbState& dbState, const TId& requestedId);
        void RespondOnExternalId(NHttp::TRequestReply& reply, const TDbState& dbState, const TId& requestedId, bool realtimeForbidden);
        void RespondOnInternalId(NHttp::TRequestReply& reply, const TDbState& dbState, const TId& requestedId, bool realtimeForbidden);
        void RespondOnTurboId(NHttp::TRequestReply& reply, const TId& requestedId);

        TMatch::TMatchedIds GetOfflineInternalIds(const TMatch& match);

        NYtDynTables::TKvDatabase& ReplicaDatabase;
        const TTurboDecryptor& TurboDecryptor;
    };
}
